---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：41-kubectl api-versions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` - api-versionsコマンド本体
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | api-versionsはgroup/version形式でAPIバージョンを出力する | E-01 行59-60 Short/Long説明 | ○ |
| C-02 | 引数を受け付けない | E-01 行73-75 argsチェック | ○ |
| C-03 | DiscoveryClientのキャッシュを無効化して最新データを取得する | E-01 行84 Invalidate()呼び出し | ○ |
| C-04 | ServerGroups()でグループ一覧を取得する | E-01 行86 ServerGroups()呼び出し | ○ |
| C-05 | ExtractGroupVersionsでバージョン文字列を抽出する | E-01 行90 ExtractGroupVersions()呼び出し | ○ |
| C-06 | 結果をアルファベット順ソートする | E-01 行91 sort.Strings()呼び出し | ○ |
| C-07 | コマンド固有のフラグは存在しない | E-01 行57-69 フラグ追加処理なし | ○ |
| C-08 | DisableFlagsInUseLine: trueが設定されている | E-01 行62 | ○ |
| C-09 | 関連機能として109-API Resources表示が主機能 | E-03 画面No41の行 | ○ |
| C-10 | 関連機能として1-API Serverコアが連携 | E-03 画面No41の行 | ○ |
| C-11 | Other Commandsカテゴリに属する | E-02 画面No41の行 | ○ |
| C-12 | エラー時に「couldn't get available api versions from server」を出力 | E-01 行89 エラーメッセージ | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純な読み取り専用コマンドであり、実装が小さくリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] DiscoveryClientのServerGroups()が実際にどのAPIエンドポイントを呼ぶか確認
- [ ] 認証・認可に関する記述が正確か確認
